/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.corgilib.registries;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.serialization.DynamicOps;
import corgitaco.corgilib.platform.ModPlatform;
import corgitaco.corgilib.serialization.jankson.JanksonJsonOps;
import corgitaco.corgilib.serialization.jankson.JanksonUtil;
import corgitaco.corgilib.shadow.blue.endless.jankson.JsonElement;
import it.unimi.dsi.fastutil.Function;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2378;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6903;

public class WorldRegistryExportCommand {
    public static final Map<String, String> COMMENTS = (Map)class_156.method_654(new HashMap(), map -> {});

    public static LiteralArgumentBuilder<class_2168> registerWorldRegistryExportCommand(CommandDispatcher<class_2168> dispatcher) {
        return WorldRegistryExportCommand.registerWorldRegistryExportCommand(dispatcher, "worldRegistryExport");
    }

    public static LiteralArgumentBuilder<class_2168> registerWorldRegistryExportCommand(CommandDispatcher<class_2168> dispatcher, String commandString) {
        Function withComments = cs -> (Boolean)((CommandContext)cs).getArgument("With comments?", Boolean.class);
        Function builtin = cs -> (Boolean)((CommandContext)cs).getArgument("Generate Built In Registries?", Boolean.class);
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)commandString).requires(stack -> stack.method_9259(4))).executes(cs -> WorldRegistryExportCommand.generateWorldRegistryExport(true, false, (CommandContext<class_2168>)cs))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"With comments?", (ArgumentType)BoolArgumentType.bool()).executes(cs -> WorldRegistryExportCommand.generateWorldRegistryExport((Boolean)withComments.apply((Object)cs), false, (CommandContext<class_2168>)cs))).then(class_2170.method_9244((String)"Generate Built In Registries?", (ArgumentType)BoolArgumentType.bool()).executes(cs -> WorldRegistryExportCommand.generateWorldRegistryExport((Boolean)withComments.apply((Object)cs), (Boolean)builtin.apply((Object)cs), (CommandContext<class_2168>)cs))));
    }

    public static int generateWorldRegistryExport(boolean withComments, boolean builtin, CommandContext<class_2168> commandSource) {
        class_2168 source = (class_2168)commandSource.getSource();
        if (!source.method_9211().method_3724() || source.method_9211().method_3788() > 1) {
            source.method_9213((class_2561)class_2561.method_43471((String)"corgilib.worldRegistryExport.singleplayer").method_27692(class_124.field_1061));
            return 0;
        }
        Path finalExportPath = ModPlatform.PLATFORM.modConfigDir().resolve("world_registry_export").resolve(builtin ? "builtin" : "world").resolve("data");
        class_5250 exportFileComponent = class_2561.method_43470((String)finalExportPath.toString()).method_27692(class_124.field_1073).method_27694(text -> text.method_27703(class_5251.method_27718((class_124)class_124.field_1075)).method_10958(new class_2558(class_2558.class_2559.field_11746, finalExportPath.toString())).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43471((String)"corgilib.clickevent.hovertext"))));
        if (finalExportPath.toFile().exists()) {
            source.method_9213((class_2561)class_2561.method_43469((String)"corgilib.worldRegistryExport.exists", (Object[])new Object[]{exportFileComponent}).method_27692(class_124.field_1061));
            return 0;
        }
        source.method_9226((class_2561)class_2561.method_43471((String)"corgilib.worldRegistryExport.starting").method_27692(class_124.field_1054), true);
        try {
            WorldRegistryExportCommand.generateFiles(builtin, source, finalExportPath, withComments);
            WorldRegistryExportCommand.createPackMCMeta(finalExportPath.getParent(), builtin);
            source.method_9226((class_2561)class_2561.method_43469((String)"corgilib.worldRegistryExport.success", (Object[])new Object[]{exportFileComponent}).method_27692(class_124.field_1060), true);
            return 1;
        }
        catch (IOException e) {
            source.method_9213((class_2561)class_2561.method_43471((String)"corgilib.worldRegistryExport.failed"));
            e.printStackTrace();
            return 0;
        }
    }

    private static void generateFiles(boolean builtin, class_2168 source, Path exportPath, boolean withComments) throws IOException {
        Files.createDirectories(exportPath, new FileAttribute[0]);
        class_5455.class_6893 registry = builtin ? class_5455.method_40314() : source.method_9225().method_30349();
        class_6903 ops = class_6903.method_40414((DynamicOps)JanksonJsonOps.INSTANCE, (class_5455)registry);
        for (class_5455.class_5456 knownRegistry : class_5455.method_39674()) {
            WorldRegistryExportCommand.dumpRegistryCap(exportPath, (class_5455)registry, (DynamicOps<JsonElement>)ops, knownRegistry, withComments);
        }
    }

    private static <T> void dumpRegistryCap(Path root, class_5455 registryAccess, DynamicOps<JsonElement> ops, class_5455.class_5456<T> data, boolean withComments) {
        class_5321 resourceKey = data.comp_293();
        class_2378 registry = registryAccess.method_33309(resourceKey);
        for (Map.Entry resourceKeyTEntry : registry.method_29722()) {
            class_5321 resourceKeyTEntryKey = (class_5321)resourceKeyTEntry.getKey();
            Path resolve = root.resolve(resourceKeyTEntryKey.method_29177().method_12836());
            String resourceKeyNamespace = resourceKey.method_29177().method_12836();
            if (ModPlatform.PLATFORM.getPlatformName().equalsIgnoreCase("Forge") && !resourceKeyNamespace.equalsIgnoreCase("minecraft")) {
                resolve = resolve.resolve(resourceKeyNamespace);
            }
            Path path = resolve.resolve(resourceKey.method_29177().method_12832()).resolve(resourceKeyTEntryKey.method_29177().method_12832() + ".json");
            try {
                Optional jsonElement = data.comp_294().encodeStart(ops, resourceKeyTEntry.getValue()).result();
                if (!jsonElement.isPresent()) continue;
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                JsonElement loadedElement = (JsonElement)jsonElement.get();
                if (!withComments) continue;
                loadedElement = JanksonUtil.addCommentsAndAlphabeticallySortRecursively(COMMENTS, loadedElement, "", true);
                Files.write(path, loadedElement.toJson(JanksonUtil.JSON_GRAMMAR).getBytes(), new OpenOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void createPackMCMeta(Path path, boolean builtIn) throws IOException {
        String fileString = "{\n\t\"pack\":{\n\t\t\"pack_format\": 10,\n\t\t\"description\": \" Generated world gen datapack from " + (builtIn ? "built in registries" : "current world registries") + ".\"\n\t}\n}\n";
        Files.write(path.resolve("pack.mcmeta"), fileString.getBytes(), new OpenOption[0]);
    }
}

